#include <bits/stdc++.h>
using namespace std;

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;
    int koren = sqrt(n);

    vector<long long> iskustva(n + 1);
    vector<long long> prefiks_zbir(n + 1);
    prefiks_zbir[0] = 0;

    for (int i = 1; i <= n; ++i) {
        cin >> iskustva[i];
        prefiks_zbir[i] = prefiks_zbir[i - 1] + iskustva[i];
    }
    unordered_map<long long, int> prvi_pojava, poslednji_pojava;
    vector<long long> moguce_sume;
    prvi_pojava[0] = 1;
    for (int i = 1; i <= n; ++i) {
        if (!prvi_pojava.count(prefiks_zbir[i])) {
            prvi_pojava[prefiks_zbir[i]] = i + 1;
        } else {
            poslednji_pojava[prefiks_zbir[i]] = i;
        }
    }
    for (auto &[suma, kraj] : poslednji_pojava) {
        moguce_sume.push_back(suma);
    }
    vector<long long> sve_vrednosti = iskustva;
    sort(sve_vrednosti.begin() + 1, sve_vrednosti.end());
    sve_vrednosti.erase(unique(sve_vrednosti.begin() + 1, sve_vrednosti.end()), sve_vrednosti.end());
    unordered_map<long long, int> kompresija;
    for (int i = 1; i < sve_vrednosti.size(); ++i) {
        kompresija[sve_vrednosti[i]] = i;
    }
    for (int i = 1; i <= n; ++i) {
        iskustva[i] = kompresija[iskustva[i]];
    }
    vector<tuple<int, int, int>> upiti;
    for (auto suma : moguce_sume) {
        int levo = prvi_pojava[suma];
        int desno = poslednji_pojava[suma];
        upiti.emplace_back(levo / koren, desno, levo);
    }
    sort(upiti.begin(), upiti.end(), [](const auto &a, const auto &b) {
        if (get<0>(a) != get<0>(b)) return get<0>(a) < get<0>(b);
        return get<0>(a) & 1 ? get<1>(a) > get<1>(b) : get<1>(a) < get<1>(b);
    });

    int levo = 1, desno = 0, maksimum = 0;
    vector<int> brojac(n + 1, 0);

    for (auto &[blok, kraj, pocetak] : upiti) {
        while (levo < pocetak) brojac[iskustva[levo++]]--;
        while (desno > kraj) brojac[iskustva[desno--]]--;
        while (levo > pocetak) maksimum = max(maksimum, ++brojac[iskustva[--levo]]);
        while (desno < kraj) maksimum = max(maksimum, ++brojac[iskustva[++desno]]);
    }

    cout<<maksimum;
    return 0;
}